/* 
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *  
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "reg.h"
#include <stdlib.h>
#include <stdio.h>
#include "Shlwapi.h"
#include "filetool.h"

char IniFileName[MAX_PATH]={0};





/*----------------------------------------------------------------------------------------------------------*/
/* length of string in bytes including null termination character; works for ASCII and UNICODE */
DWORD StringLengthBytes(const TCHAR *sString)
{
	return ((_tcslen(sString)+1)*sizeof(TCHAR));
}


BOOL InitIniFile(void)
{
	if (strlen(IniFileName) > 5)  { return TRUE; }

	GetModulePath(IniFileName);

	strcat_s(IniFileName,MAX_PATH,"\\Arnold.ini");
	return TRUE;
}


/*
BOOL	MyApp_Registry_CheckKeyPresent()
{
	BOOL Present = FALSE;

	// open current user, and get settings for Arnold
	HKEY SoftwareKey;

	// open Software tab for current user
	if (RegOpenKeyEx(HKEY_CURRENT_USER,_T("Software"), 0, KEY_READ, &SoftwareKey)==ERROR_SUCCESS)
	{
		HKEY ArnoldKey;

		// open Arnold key
		if (RegOpenKeyEx(SoftwareKey, PUB_szProfileArnold, 0, KEY_READ, &ArnoldKey)==ERROR_SUCCESS)
		{
			// found Arnold key. Retrieve settings

			// close arnold key
			RegCloseKey(ArnoldKey);

			Present = TRUE;
		}
		else
		{
			// get default settings

		}

		// close software key
		RegCloseKey(SoftwareKey);
	}

	return Present;
}
*/
/*
BOOL	MyApp_Registry_CheckValuePresent(const TCHAR *ValueName)
{
	DWORD Type;
	DWORD Size;

	if (RegQueryValueEx(CurrentKey, ValueName, 0, &Type, NULL, &Size)==ERROR_SUCCESS)
	{
		return TRUE;
	}

	return FALSE;
}
*/

// add a null-terminated string value to the selected key
BOOL MyApp_Registry_SetString(const TCHAR * Key, const TCHAR *ValueName, const TCHAR *ValueString)
{

	if (!InitIniFile()) return FALSE;
//	if (ValueString == NULL) || (ValueString == '\0') {
//	}

	 WritePrivateProfileString(Key,ValueName,ValueString,IniFileName);
		
	return TRUE;
}


// add a dword value to the selected key
BOOL MyApp_Registry_SetValue(const TCHAR * Key, const TCHAR *ValueName, int ValueData)
{
	char buffer [255];

	if (!InitIniFile()) return FALSE;

	 _itoa_s (ValueData,buffer,sizeof(buffer),10);
	 WritePrivateProfileString(Key,ValueName,buffer,IniFileName);
		
	return TRUE;
}


// get value data from registry 
int MyApp_Registry_GetValue(const TCHAR * Key, const TCHAR *ValueName)
{

	char buffer [255];

	if (!InitIniFile()) return FALSE;

	GetPrivateProfileString(Key,ValueName,NULL,buffer,sizeof(buffer),IniFileName);

	return atoi(buffer);
}

BOOL MyApp_Registry_GetString(const TCHAR * Key, const TCHAR *ValueName, char *pBuffer)
{
	int a;

	if (!InitIniFile()) return FALSE;

	a = sizeof(pBuffer);

	GetPrivateProfileString(Key,ValueName,NULL,pBuffer,255,IniFileName);

	return TRUE;
}

BOOL Settings_IsKeyPresent(char * key)
{
	return FALSE;
}


/*
// get size of registry value
int	MyApp_Registry_GetValueSize(HKEY Key, const TCHAR *ValueName)
{
	DWORD Type;
	DWORD Size;

	if (RegQueryValueEx(Key, ValueName, 0, &Type, NULL, &Size)==ERROR_SUCCESS)
	{
		return Size;
	}
	
	return 0;
}
*/

void MyApp_Registry_InitialiseKey()
{
	SetCurrentDirectory(IniFileName);
	strcat_s(IniFileName,MAX_PATH,"//Arnold.ini");
	return;
}

/*----------------------------------------------------------------------------------------------------------*/

const TCHAR *OpenString = _T("&Open");
const TCHAR *OpenWithString = _T("Open with &Arnold");
const TCHAR *DDE_DefaultKey = _T("[SetForeground][Open \"%1\"]");
const TCHAR *DDE_AppName = _T("Arnold");
const TCHAR *DDE_TopicName = _T("system");


void RegisterExtension_OpenKeySetup(const EXTENSION_INFO *pExtensionInfo,HKEY hOpenKey, BOOL fOpenWith)
{
	DWORD dwDisposition;
	HKEY hCommandKey;
	HKEY hDDEKey;

	if (!fOpenWith)
	{
		RegSetValueEx(hOpenKey, NULL, 0, REG_SZ, (const BYTE *)OpenString,StringLengthBytes(OpenString));
	}

	if (RegCreateKeyEx(hOpenKey, _T("command"), 0, _T(""),REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL,&hCommandKey, &dwDisposition)==ERROR_SUCCESS)
	{
		TCHAR Buffer[256];

		sprintf_s(Buffer,sizeof(Buffer),_T("\"%s\" \"%%1\""),pExtensionInfo->pApplicationPath);

		RegSetValueEx(hCommandKey, NULL, 0, REG_SZ, (const BYTE *)Buffer, StringLengthBytes(Buffer));

		RegCloseKey(hCommandKey);
	}

	if (RegCreateKeyEx(hOpenKey, _T("ddeexec"),0, _T(""),REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hDDEKey, &dwDisposition)==ERROR_SUCCESS)
	{
		HKEY hApplicationKey;

		// set the default key
		RegSetValueEx(hDDEKey, NULL, 0, REG_SZ, (const BYTE *)DDE_DefaultKey, StringLengthBytes(DDE_DefaultKey));

		if (RegCreateKeyEx(hDDEKey, _T("application"),0, _T(""),REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hApplicationKey, &dwDisposition)==ERROR_SUCCESS)
		{

			RegSetValueEx(hApplicationKey, NULL, 0, REG_SZ, (const BYTE *)DDE_AppName, StringLengthBytes(DDE_AppName));

			RegCloseKey(hApplicationKey);
		}

		if (RegCreateKeyEx(hDDEKey, _T("topic"),0, (LPTSTR)_T(""),REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hApplicationKey, &dwDisposition)==ERROR_SUCCESS)
		{
			RegSetValueEx(hApplicationKey, NULL, 0, REG_SZ, (const BYTE *)DDE_TopicName, StringLengthBytes(DDE_TopicName));

			RegCloseKey(hApplicationKey);
		}

		RegCloseKey(hDDEKey);
	}
}


void	RegisterExtension(const EXTENSION_INFO *pExtensionInfo, BOOL fOpenWith)
{
	HKEY hExtensionKey;
	DWORD dwDisposition;
	/* the actual link used */
	TCHAR *pExtensionLinkName = NULL;

	if (RegCreateKeyEx(HKEY_CLASSES_ROOT, pExtensionInfo->pExtensionKeyName,0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hExtensionKey, &dwDisposition)==ERROR_SUCCESS)
	{
		/* create if it doesn't exist, otherwise just opens it */
		BOOL fExists = FALSE;

		if (dwDisposition==REG_OPENED_EXISTING_KEY)
		{
			/* if friendly then use existing key; don't replace with our own */
			if (fOpenWith)
			{
				DWORD dwLength;
				DWORD dwType;
				dwLength = 0;

				/* query existing link */
				if (RegQueryValueEx(hExtensionKey, NULL, NULL, &dwType, NULL, &dwLength)==ERROR_SUCCESS)
				{
					pExtensionLinkName = (TCHAR *)malloc(dwLength);

					if (pExtensionLinkName)
					{
						DWORD dwType;

						RegQueryValueEx(hExtensionKey, NULL, NULL, &dwType, (BYTE *)pExtensionLinkName, &dwLength);
		
						fExists = TRUE;
					}
				}
			}
		}
		
		if (!fExists)
		{
			DWORD nLen = StringLengthBytes(pExtensionInfo->pExtensionLinkKeyName);
			pExtensionLinkName = (TCHAR *)malloc(nLen);
			
			if (pExtensionLinkName)
			{
				memcpy(pExtensionLinkName, pExtensionInfo->pExtensionLinkKeyName,nLen);
			}
			
			/* replace value of default key */
			RegSetValueEx(hExtensionKey, NULL, 0, REG_SZ, (const BYTE *)pExtensionLinkName, nLen);
		}

		RegCloseKey(hExtensionKey);
	}

	if (pExtensionLinkName!=NULL)
	{
		DWORD dwDisposition;

		/* create it if it doesn't exist, otherwise open it */
		if (RegCreateKeyEx(HKEY_CLASSES_ROOT, pExtensionLinkName, 0, _T(""),REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,NULL, &hExtensionKey,&dwDisposition)==ERROR_SUCCESS)
		{
			if (!fOpenWith)
			{
				/* if not friendly, replace description and icon for our own */
				HKEY hDefaultIcon;
				TCHAR Buffer[256];

				/* set the description of the extension */
				RegSetValueEx(hExtensionKey, NULL, 0, REG_SZ, (const BYTE *)pExtensionInfo->pExtensionDescription, StringLengthBytes(pExtensionInfo->pExtensionDescription));
			
				sprintf_s(Buffer,sizeof(Buffer),_T("\"%s\",-%d"),pExtensionInfo->pApplicationPath,pExtensionInfo->nIconIndex);

				if (RegCreateKeyEx(hExtensionKey,_T("DefaultIcon"), 0, _T(""),REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hDefaultIcon, &dwDisposition)==ERROR_SUCCESS)
				{
					RegSetValueEx(hDefaultIcon, NULL, 0, REG_SZ, (const BYTE *)Buffer, StringLengthBytes(Buffer));
				
					RegCloseKey(hDefaultIcon);
				}
			}		

			{
				HKEY hShellKey;

				if (RegCreateKeyEx(hExtensionKey,_T("shell"), 0, _T(""), REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS, NULL, &hShellKey, &dwDisposition)==ERROR_SUCCESS)
				{
					HKEY hOpenKey;
					const TCHAR *sKey;

					/* if not friendly replace the default "open" with our own */
					/* if friendly, create a open with */
					if (!fOpenWith)
					{
						sKey = _T("open");
					}
					else
					{
						sKey = OpenWithString;
					}

					if (RegCreateKeyEx(hShellKey,sKey, 0, _T(""),REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL,&hOpenKey, &dwDisposition)==ERROR_SUCCESS)
					{
						RegisterExtension_OpenKeySetup(pExtensionInfo,hOpenKey, fOpenWith);

						RegCloseKey(hOpenKey);

					}

					RegCloseKey(hShellKey);
				}
			}

			RegCloseKey(hExtensionKey);
		}

		free(pExtensionLinkName);

	}

}

